// Rad_StatusBar.js | Radnen 2008 //

function StatusBar(x, y, w, h, value, max)
{
	if (this instanceof StatusBar == false)
	return new StatusBar(x, y, w, h, value, max);
	
	this.x = x;
	this.y = y;
	this.w = w;
	this.h = h;
	this.value = value;
	this.max = max;
	this.colors = [Colors.green, Colors.red];
	this.interval = Math.floor(this.max / this.colors.length);
	this.onEmpty = function() {};
}

StatusBar.prototype.blit = function()
{
	var current = 0;
	for (var i = 0; i < this.colors.length; ++i)
	{
		if (this.value < i*this.interval && this.value > i*this.interval-this.interval)
			current = i;
	}
	
	Rectangle(this.x, this.y, Math.floor((this.value/this.max)*this.w), this.h, this.colors[current]);
}